package gov.va.med.mhv.health.repository;

import gov.va.med.mhv.health.model.ChemistryLab;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ChemistryLabRepository   extends JpaRepository<ChemistryLab, Long>{
	
	 @Query("select a from ChemistryLab a where a.patientId = :patientId order by a.collectedDatePrecise desc")
	 List<ChemistryLab>  getChemLabsForPatient(@Param ("patientId") Long patientId);
	 
	 @Query("select a from ChemistryLab a where a.patientId = :patientId order by a.collectedDatePrecise desc")
	 List<ChemistryLab>  getDashboardChemLabsForPatient(@Param ("patientId") Long patientId,Pageable page);

	 
}
